﻿if (script.onAwake) {
	script.onAwake();
	return;
};
function checkUndefined(property, showIfData){
   for (var i = 0; i < showIfData.length; i++){
       if (showIfData[i][0] && script[showIfData[i][0]] != showIfData[i][1]){
           return;
       }
   }
   if (script[property] == undefined){
      throw new Error('Input ' + property + ' was not provided for the object ' + script.getSceneObject().name);
   }
}
// @input bool editDebugSettings
checkUndefined("editDebugSettings", []);
// @ui {"widget":"group_start", "label":"Debug Statements", "showIf":"editDebugSettings"}
// @input bool printDebugStatements = "true" {"label":"Print Info"}
checkUndefined("printDebugStatements", [["editDebugSettings",true]]);
// @input bool printWarningStatements = "true" {"label":"Print Warnings"}
checkUndefined("printWarningStatements", [["editDebugSettings",true]]);
// @ui {"widget":"group_end"}
// @ui {"widget":"separator"}
// @input string leaderboardName = "" {"hint":"Changing leaderboard name will reset scores"}
checkUndefined("leaderboardName", []);
// @input boolean autoInitialize = "true"
checkUndefined("autoInitialize", []);
// @input int scoreLifetimeOption = "1" {"label":"Score Reset Interval", "widget":"combobox", "values":[{"label":"Day", "value":0}, {"label":"Week", "value":1}, {"label":"Month", "value":2}, {"label":"Year", "value":3}]}
checkUndefined("scoreLifetimeOption", []);
// @input string leaderboardStartDate = "12/31/2024" {"hint":"In format mm/dd/yyyy"}
checkUndefined("leaderboardStartDate", []);
// @input int scoreOrdering = "1" {"widget":"combobox", "values":[{"label":"Descending", "value":1}, {"label":"Ascending", "value":2}]}
checkUndefined("scoreOrdering", []);
// @input int userLimit = "10" {"hint":"Maximum user limit is 50"}
checkUndefined("userLimit", []);
// @ui {"widget":"separator"}
// @input int renderOrder = "1"
checkUndefined("renderOrder", []);
// @input int backgroundCustomization = "2" {"widget":"combobox", "values":[{"label":"None", "value":0}, {"label":"Bitmoji", "value":1}, {"label":"Texture", "value":2}]}
checkUndefined("backgroundCustomization", []);
// @input Asset.Texture backgroundTexture {"showIf":"backgroundCustomization", "showIfValue":2}
checkUndefined("backgroundTexture", [["backgroundCustomization",2]]);
// @input string customStickerId {"hint":"Please enter bitmoji sticker id or leave empty to use selfie sticker", "showIf":"backgroundCustomization", "showIfValue":1}
checkUndefined("customStickerId", [["backgroundCustomization",1]]);
// @ui {"widget":"group_start", "label":"Customisable Prefabs", "showIf":"customisablePrefabs"}
// @input Asset.ObjectPrefab leaderboardEntry {"hint":"This Prefab contains LeaderboardEntry script which can be customised"}
checkUndefined("leaderboardEntry", [["customisablePrefabs",true]]);
// @input Asset.ObjectPrefab cameraBadgePrefab
checkUndefined("cameraBadgePrefab", [["customisablePrefabs",true]]);
// @ui {"widget":"group_end"}
// @ui {"widget":"separator"}
// @input Asset.ObjectPrefab leaderboardVisuals
checkUndefined("leaderboardVisuals", []);
// @input Asset.ObjectPrefab leaderboardEntryFallback
checkUndefined("leaderboardEntryFallback", []);
// @input Asset.ObjectPrefab componentDependencies
checkUndefined("componentDependencies", []);
// @input bool useCameraBadge = false
checkUndefined("useCameraBadge", []);
// @input Asset.LeaderboardModule leaderboardModule
checkUndefined("leaderboardModule", []);
// @input Asset.BitmojiModule bitmojiModule
checkUndefined("bitmojiModule", []);
// @input Asset.RemoteMediaModule remoteMediaModule
checkUndefined("remoteMediaModule", []);
var scriptPrototype = Object.getPrototypeOf(script);
if (!global.BaseScriptComponent){
   function BaseScriptComponent(){}
   global.BaseScriptComponent = BaseScriptComponent;
   global.BaseScriptComponent.prototype = scriptPrototype;
   global.BaseScriptComponent.prototype.__initialize = function(){};
   global.BaseScriptComponent.getTypeName = function(){
       throw new Error("Cannot get type name from the class, not decorated with @component");
   }
}
var Module = require("../../../../../Modules/Src/Src/Misc/Leaderboard.lsc/CC Resources/LeaderboardComponent");
Object.setPrototypeOf(script, Module.LeaderboardComponent.prototype);
script.__initialize();
if (script.onAwake) {
   script.onAwake();
}
